/*
 * Decompiled with CFR 0.152.
 */
package jclass.table3.bean;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import jclass.beans.GroupPanel;
import jclass.table3.bean.ColorEditor;
import jclass.table3.bean.ColorEditorSample;

class ColorChooser
extends Dialog
implements ActionListener,
TextListener {
    private ColorEditor editor;
    private TextField red;
    private TextField green;
    private TextField blue;
    private ColorEditorSample sample;
    private Button buttonOK;

    ColorChooser(ColorEditor colorEditor) {
        super(colorEditor.findParent(), "Select Custom Color", true);
        this.editor = colorEditor;
        Color color = colorEditor.getColor();
        if (color == null) {
            color = Color.black;
        }
        this.red = new TextField(String.valueOf(color.getRed()), 4);
        this.green = new TextField(String.valueOf(color.getGreen()), 4);
        this.blue = new TextField(String.valueOf(color.getBlue()), 4);
        GroupPanel groupPanel = new GroupPanel("RGB color");
        groupPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        groupPanel.add((Component)new Label("Red"), gridBagConstraints);
        groupPanel.add((Component)this.red, gridBagConstraints);
        ++gridBagConstraints.gridy;
        groupPanel.add((Component)new Label("Green"), gridBagConstraints);
        groupPanel.add((Component)this.green, gridBagConstraints);
        ++gridBagConstraints.gridy;
        groupPanel.add((Component)new Label("Blue"), gridBagConstraints);
        groupPanel.add((Component)this.blue, gridBagConstraints);
        this.sample = new ColorEditorSample(color);
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(2));
        panel.add(this.sample);
        this.buttonOK = new Button("OK");
        Button button = new Button("Cancel");
        Panel panel2 = new Panel();
        panel2.setLayout(new FlowLayout(2));
        panel2.add(this.buttonOK);
        panel2.add(button);
        this.setLayout(new BorderLayout(10, 4));
        this.add("Center", groupPanel);
        this.add("East", panel);
        this.add("South", panel2);
        this.red.addTextListener(this);
        this.green.addTextListener(this);
        this.blue.addTextListener(this);
        button.addActionListener(this);
        this.buttonOK.addActionListener(this);
        this.pack();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.buttonOK) {
            this.editor.selectColor(this.sample.getColor());
        }
        ((Component)this).setVisible(false);
    }

    public void textValueChanged(TextEvent textEvent) {
        this.sample.setColor(new Color(this.getColor(this.red), this.getColor(this.green), this.getColor(this.blue)));
    }

    private int getColor(TextField textField) {
        try {
            int n = new Integer(textField.getText());
            if (n < 0) {
                n = 0;
            }
            if (n > 255) {
                n = 255;
            }
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }
}

